package gov.va.med.mhv.usermgmt.data.repository;

import java.util.List;

import gov.va.med.mhv.usermgmt.data.model.EmergencyContact;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface EmergencyContactRepository extends JpaRepository<EmergencyContact, Long> {
	/**
	 * 
	 * @param userName
	 * @return
	 */
	@Query("select e from EmergencyContact e where e.userProfileId = :userProfileId")
	public List<EmergencyContact> findByUserProfileId(@Param("userProfileId") Long userProfileId);
		
	@Query("select e from EmergencyContact e where e.emergencyContactId = :emergencyContactId")
	public EmergencyContact findByEmergencyContactId(@Param("emergencyContactId") Long emergencyContactId);
	
	@Query("select e from EmergencyContact e where e.userProfileId = :userProfileId and e.primary = :primary")
	public List<EmergencyContact> findByUserProfileIdAndPrimary(@Param("userProfileId") Long userProfileId, @Param("primary") Boolean primary);
	
}